/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.io.BitInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LzwInputStream
extends InputStream {
    private BitInputStream is;
    private List<int[]> dictionary;
    private Queue<Integer> outputBuffer = new ConcurrentLinkedQueue<Integer>();
    private boolean newBuffer = true;
    private int k;
    private int[] w;
    private int[] entry;

    public LzwInputStream(BitInputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        if (this.outputBuffer.isEmpty()) {
            this.fillBuffer();
        }
        return this.outputBuffer.remove();
    }

    public void fillBuffer() throws IOException {
        if (this.dictionary == null) {
            this.is.setRequestedNumberOfBits(9);
            this.dictionary = new ArrayList<int[]>();
            for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
                this.dictionary.add(new int[]{i});
            }
            this.dictionary.add(new int[]{256});
        }
        if (this.newBuffer) {
            this.k = this.is.read();
            this.outputBuffer.add(this.k);
            if (this.k == -1) {
                return;
            }
            this.w = new int[]{this.k};
            this.newBuffer = false;
        }
        this.k = this.is.read();
        if (this.k == -1) {
            this.outputBuffer.add(this.k);
            return;
        }
        if (this.k == 256) {
            this.dictionary = null;
            this.is.setRequestedNumberOfBits(9);
            this.k = 0;
            this.w = null;
            this.entry = null;
            this.newBuffer = true;
            this.fillBuffer();
            return;
        }
        if (this.k < this.dictionary.size()) {
            this.entry = this.dictionary.get(this.k);
        } else if (this.k == this.dictionary.size()) {
            this.entry = new int[this.w.length + 1];
            System.arraycopy(this.w, 0, this.entry, 0, this.w.length);
            this.entry[this.w.length] = this.w[0];
        } else {
            throw new IOException("Invalid code of <" + this.k + "> encountered");
        }
        for (int i : this.entry) {
            this.outputBuffer.add(i);
        }
        int[] newEntry = new int[this.w.length + 1];
        System.arraycopy(this.w, 0, newEntry, 0, this.w.length);
        newEntry[this.w.length] = this.entry[0];
        this.dictionary.add(newEntry);
        this.w = this.entry;
        if ((this.dictionary.size() ^ this.is.getBitMask()) == 0) {
            this.is.increaseRequestedNumberOfBits();
        }
    }

    public void clearDictionary() {
        this.dictionary = null;
        this.is.setRequestedNumberOfBits(9);
        this.is.clearRemainingBitsOfData();
        this.outputBuffer.clear();
        this.k = 0;
        this.w = null;
        this.entry = null;
        this.newBuffer = true;
    }

    public void clearData() {
        this.is.clearRemainingBitsOfData();
        this.outputBuffer.clear();
    }
}

